%function [x_axis,y_axis,z_axis] = get_Vbias_vs_B
%% set the default font size for all figure
set(0,'defaultAxesFontSize',20)

%% ask the user to load the file
uiwait(msgbox('Choose the file(s) you want to analyze'))
[fileName,pathName,~]=uigetfile('*.dat', 'Open file .dat','MultiSelect','on');
%[fileName,pathName,~] = uigetfile('*.dat', 'Open file .dat');

%% get the data by reading the file
if iscell(fileName)
    num_file = length(fileName);
else
    num_file = size(fileName,1);
end
if num_file>1
for i=1:num_file
    file(i) = importdata(fullfile(pathName,fileName{i}));
end
else
    file(1) = importdata(fullfile(pathName,fileName)); 
end

%% ask for the factor to convert Bx to Btot
prompt_Bx = 'enter the factor for converting Bx (T) to B (T)';
dlgtitle_Bx = 'Input';
user_val_Bx = inputdlg(prompt_Bx,dlgtitle_Bx);
Bx_val = str2num(user_val_Bx{1});

%% ask for the input lockin amplification
prompt_Vac = 'enter input lockin amplification in Amps';
dlgtitle_Vac = 'Input';
user_val_Vac = inputdlg(prompt_Vac,dlgtitle_Vac);
Vac_val = str2num(user_val_Vac{1});

%% ask for the measured lockin current (lockinX) amplification
prompt_Imeas = 'enter the amplification for measured lockin current (lockinX) in Amps';
dlgtitle_Imeas = 'Input';
user_val_Imeas = inputdlg(prompt_Imeas,dlgtitle_Imeas);
Imeas_val = str2num(user_val_Imeas{1});

% %% Reading the size of Vbias and getting Vbias values
% for k=1:num_file 
% str_Vbias = char(file(k).textdata(6));
% str_split = strsplit(str_Vbias);
% size_Vbias(k) = str2num(str_split{3});
% Vbias(1:size_Vbias(k),k) = file(k).data(1:size_Vbias(k),1)*Vbias_val;
% end

%% Reading the size of Vgate and getting Vgate values
str_Vgate = char(file(1).textdata(6));
str_split = strsplit(str_Vgate);
size_Vgate = str2num(str_split{3});

Vgate = file(1).data(1:size_Vgate,1);%in mV

%% Reading the size of Bx
for k=1:num_file
    size_Bx(k,:) = size(file(k).data(:,1))/size_Vgate;
end

for k=1:num_file
    s=1;
    %Vmeasure = zeros(size_Vbias(k),size_Bx(k,1));
    Imeasure = zeros(size_Vgate,size_Bx(k,1));
    Bx = zeros(1,size_Bx(k,1));
    for i=1:size_Bx(k,1)
        %Vmeasure(1:size_Vbias(k),i)=file(k).data(s:s+size_Vbias(k)-1,6)*Vmeas_val;
        Imeasure(1:size_Vgate,i)=file(k).data(s:s+size_Vgate-1,7)*Imeas_val;%lockinX value in Amps
        Bx(i)=file(k).data(s,2);
        s=s+size_Vgate;
        %p=p+1;
    end
dIdV(k).all = Imeasure/Vac_val;
%Vmeas(k).all=Vmeasure;
Bx1(k).all=Bx;
end

% for k=1:num_file
%     if size(Vmeas(k).all,1)==max(size_Vbias)
%         Vbias_plot=Vmeas(k).all(:,1);
%     end
% end

%% Making sure that all the scans are from positive to negative Bx values
for k=1:num_file
    if Bx1(k).all(1)-Bx1(k).all(2)<0
        Bx1(k).all=flip(Bx1(k).all);
        dIdV(k).all=flip(dIdV(k).all,2);
        %Vmeas(k).all=flip(Vmeas(k).all,2);
    end
    first_element_Bx(k)=Bx1(k).all(1);
end

%% Removing overlapping regions in Bx values and choosing to display only the dIdV for which the Vmeas range is shorter
[sort_first_element_Bx, sort_index_1st_element_Bx]=sort(first_element_Bx,'descend');
for k = 1:num_file-1
    kprime = sort_index_1st_element_Bx(k);
    kprime2 = sort_index_1st_element_Bx(k+1);
    if Bx1(kprime).all(end)>Bx1(kprime2).all(1)
        for j=1:length(Bx1(kprime).all)
            if Bx1(kprime).all(j)>Bx1(kprime2).all(1)
                %test=1
                Bx_new(j)=Bx1(kprime).all(j);
                dIdV_new(:,j)=dIdV(kprime).all(:,j);
                %Vmeas_new(:,j)=Vmeas(kprime).all(:,j);
            end
            Bx_final(k).final=Bx_new;
            dIdV_final(k).final=dIdV_new;
            %Vmeas_final(k).final=Vmeas_new;
        end
    else
        Bx_final(k).final=Bx1(kprime).all;
        dIdV_final(k).final=dIdV(kprime).all;
        %Vmeas_final(k).final=Vmeas(kprime).all;
    end
end

Bx_final(num_file).final=Bx1(sort_index_1st_element_Bx(num_file)).all;
dIdV_final(num_file).final=dIdV(sort_index_1st_element_Bx(num_file)).all;
%Vmeas_final(num_file).final=Vmeas(sort_index_1st_element_Bx(num_file)).all;
        
%% Plotting them all together
%get the size of all matrices, column1 is the row dimension, column 2 is the column dimension
total_size = 0;
for k=1:num_file
    size_final_matrices(k,:)=size(dIdV_final(k).final);
    total_size=total_size+size_final_matrices(k,2);
end

dIdV_plot=NaN(size_Vgate,total_size);%length(Bx) is the total number of columns we will have in the final image
%Vmeas_plot=NaN(max(size_Vbias),total_size);

lim_col1=1;
lim_col2=size_final_matrices(1,2);
lim_row1=1;
lim_row2=size_final_matrices(1,1);
for k=1:num_file
    p=1;
    for j=lim_col1:lim_col2
        dIdV_plot(lim_row1:lim_row2,j)=dIdV_final(k).final(:,p);
        %Vmeas_plot(lim_row1:lim_row2,j)=Vmeas_final(k).final(:,p);
        Bx_plot(j)=Bx_final(k).final(p);
        p=p+1;
    end
    if k<num_file
        lim_col1=lim_col2+1;
        lim_col2=lim_col1+size_final_matrices(k+1,2)-1;
        lim_row1=(size_final_matrices(k,1)-size_final_matrices(k+1,1))/2+lim_row1;
        lim_row2=size_final_matrices(k+1,1)+lim_row1-1;
    end
end

figure;
x_axis = Bx_plot/Bx_val;
y_axis = Vgate;%in mV
z_axis = dIdV_plot;
[X,Y] = meshgrid(x_axis,y_axis);
figure1 = pcolor(X,Y,dIdV_plot);
hold on
set(figure1, 'EdgeColor', 'none');
cl=colorbar;
% caxis([2.1*10^-6 4*10^-6])
% cl.Ticks = [2.1*10^-6 2.12*10^-6 2.14*10^-6 2.16*10^-6 2.18*10^-6 2.2*10^-6];
cl.Label.String = 'G (S)';
xlabel('$B_{||}(T)$','Interpreter','latex')
ylabel('$V_{g1}(mV)$','Interpreter','latex');

%end